/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import net.adventurez.entity.NightmareEntity;
import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class SoulReaperEntity
extends Monster
implements RangedAttackMob {
    private final RangedBowAttackGoal<SoulReaperEntity> bowAttackGoal = new RangedBowAttackGoal((Monster)this, 1.0, 40, 15.0f);
    private final MeleeAttackGoal meleeAttackGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, true){

        public void m_8041_() {
            super.m_8041_();
            SoulReaperEntity.this.m_21561_(false);
        }

        public void m_8056_() {
            super.m_8056_();
            SoulReaperEntity.this.m_21561_(true);
        }
    };

    public SoulReaperEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_274367_(1.0f);
        this.f_21364_ = 30;
    }

    public static AttributeSupplier.Builder createSoulReaperAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 120.0);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{SoulReaperEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractPiglin.class, true));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverWorldAccess, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityTag) {
        entityData = super.m_6518_(serverWorldAccess, difficulty, spawnReason, entityData, entityTag);
        RandomSource random = this.m_9236_().m_213780_();
        this.m_213945_(random, difficulty);
        this.m_213946_(random, difficulty);
        this.bowAttackGoal.m_25797_(40);
        this.f_21345_.m_25352_(4, this.bowAttackGoal);
        if (spawnReason.equals((Object)MobSpawnType.COMMAND) || spawnReason.equals((Object)MobSpawnType.NATURAL) || spawnReason.equals((Object)MobSpawnType.CHUNK_GENERATION)) {
            NightmareEntity nightmareEntity = (NightmareEntity)EntityInit.NIGHTMARE.m_20615_(this.m_9236_());
            nightmareEntity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            nightmareEntity.m_6518_(serverWorldAccess, difficulty, spawnReason, null, null);
            serverWorldAccess.m_7967_((Entity)nightmareEntity);
            this.m_20329_((Entity)nightmareEntity);
        }
        return entityData;
    }

    public boolean m_142079_() {
        return false;
    }

    public static boolean canSpawn(EntityType<SoulReaperEntity> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return SoulReaperEntity.m_219013_(type, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && world.m_8055_(pos.m_6630_(3)).m_60795_() && world.m_6443_(SoulReaperEntity.class, new AABB(pos).m_82400_(60.0), EntitySelector.f_20408_).isEmpty() && random.m_188503_(7) == 0 || spawnReason == MobSpawnType.SPAWNER;
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.m_20202_() instanceof PathfinderMob) {
            PathfinderMob pathAwareEntity = (PathfinderMob)this.m_20202_();
            this.f_20883_ = pathAwareEntity.f_20883_;
        }
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public int m_5792_() {
        return 1;
    }

    public float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 1.6f;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() == MobEffects.f_19615_ ? false : super.m_7301_(effect);
    }

    public void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
    }

    public boolean m_7327_(Entity target) {
        if (target instanceof LivingEntity) {
            ((LivingEntity)target).m_7292_(new MobEffectInstance(MobEffects.f_19615_, 300));
        }
        return super.m_7327_(target);
    }

    public void m_8107_() {
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            LivingEntity target = this.m_5448_();
            if (target != null) {
                if (this.m_20270_((Entity)target) > 7.0f) {
                    if (this.m_6844_(EquipmentSlot.MAINHAND).m_41720_().equals(Items.f_42393_)) {
                        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                    }
                    this.f_21345_.m_25352_(4, this.bowAttackGoal);
                    this.f_21345_.m_25363_((Goal)this.meleeAttackGoal);
                } else {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42393_));
                    this.f_21345_.m_25352_(4, (Goal)this.meleeAttackGoal);
                    this.f_21345_.m_25363_(this.bowAttackGoal);
                }
            } else if (this.m_6844_(EquipmentSlot.MAINHAND).m_41720_().equals(Items.f_42411_)) {
                this.f_21345_.m_25352_(4, this.bowAttackGoal);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.meleeAttackGoal);
            }
        }
        super.m_8107_();
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        ItemStack itemStack = this.m_6298_(this.m_21120_(ProjectileUtil.m_37297_((LivingEntity)this, (Item)Items.f_42411_)));
        AbstractArrow persistentProjectileEntity = this.createArrowProjectile(itemStack, pullProgress);
        double d = target.m_20185_() - this.m_20185_();
        double e = target.m_20227_(0.3333333333333333) - persistentProjectileEntity.m_20186_();
        double f = target.m_20189_() - this.m_20189_();
        double g = Mth.m_14116_((float)((float)(d * d + f * f)));
        persistentProjectileEntity.m_6686_(d, e + g * 0.21, f, 1.3f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)persistentProjectileEntity);
    }

    public AbstractArrow createArrowProjectile(ItemStack arrow, float damageModifier) {
        ItemStack blackarrow = new ItemStack((ItemLike)Items.f_42412_);
        AbstractArrow persistentProjectileEntity = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)blackarrow, (float)4.0f);
        if (persistentProjectileEntity instanceof Arrow) {
            ((Arrow)persistentProjectileEntity).m_36870_(new MobEffectInstance(MobEffects.f_19615_, 200));
        }
        persistentProjectileEntity.m_36767_((byte)1);
        return persistentProjectileEntity;
    }

    public boolean m_5886_(ProjectileWeaponItem weapon) {
        return weapon == Items.f_42411_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        super.m_8061_(slot, stack);
    }

    public boolean m_6072_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundInit.SOULREAPER_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.SOULREAPER_HURT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.SOULREAPER_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12562_, 0.5f, 1.0f);
    }
}

